/**
 * Tomas' notes:
 * The program waits for the user to stop cranking or until they've
 * cranked "long enough". After that random files are played until
 * the capacitors run out of power.
 * I had to change Music_Player slightly in order to fix a linking
 * problem related to ctrlState (moved into MusicPlayer class).
 *
 * TODO
 * - work with wall wart, meaning stop playing after some time
 *   and start playing when the crank is turned again
 * - try to conserve power by letting the CPU idle when suitable
 */

/*
 * creatList.ino
 * Example sketch for MusicShield 2.0
 *
 * Copyright (c) 2012 seeed technology inc.
 * Website    : www.seeed.cc
 * Author     : Jack Shao (jacky.shaoxg@gmail.com)
 * Create Time: Mar 2014
 * Change Log :
 *
 * The MIT License (MIT)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include <SD.h>
#include <SPI.h>
#include <arduino.h>
#include <MusicPlayer.h>

#define CRANK_ANALOG_PIN     4
#define CRANK_MAX_DELAY   5000 //max ms to wait for crank to stop
#define CRANK_MIN_STOP    1000 //min ms to wait for crank to stop
#define CRANK_INTERVAL      10 //how often to read the crank
#define CRANK_THRESH         5 //analog "off" threshold

int seed;

//wait for crank to stop, and seed PRNG
void crankWaitForStopAndSeed() {
  int stopCount = 0;
  for (int l = 0; l < CRANK_MAX_DELAY/CRANK_INTERVAL; l++) {
    int crank;
    for (int x = 0; x < 5; x++) {
      int a = analogRead(x);
      seed += a;
      if (x == CRANK_ANALOG_PIN)
        crank = a;
    }
    //Serial.println(crank);
    
    if (crank <= CRANK_THRESH) {
      if (++stopCount >= CRANK_MIN_STOP/CRANK_INTERVAL)
        break;
    } else
      stopCount = 0;
    
    delay(CRANK_INTERVAL);
  }
  Serial.println("seed");
  Serial.println(seed);
  randomSeed(seed);
}

//waits for the user to start cranking
void crankWaitForStart() {
  while (analogRead(CRANK_ANALOG_PIN) <= CRANK_THRESH) {
    //we could do something here..
  }
}

void setup()
{
  Serial.begin(57600);
  
  crankWaitForStopAndSeed();

  player.begin(); //will initialize the hardware and set default mode to be normal.
  player.setPlayMode(PM_SHUFFLE_PLAY); //set mode to play shuffle
  player.scanAndPlayAll(); //If the current playlist is empty,it will add all the songs in the root directory to the playlist.

  player.setVolume(0);  //it seems 0 = highest, MAXVOL = lowest
  player.opNextSong();  //first play won't shuffle without this
}

void loop()
{
  player.play();
  //TODO: stop playing some time, if plugged into the wall
}

